/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ColorSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@ModuleInfo(name="Jump Effect", category=ModuleCategory.VISUALS, desc="\u042d\u0444\u0444\u0435\u043a\u0442 \u0447\u0430\u0441\u0442\u0438\u0446 \u043f\u0440\u0438 \u043f\u0440\u044b\u0436\u043a\u0435")
public class JumpEffect
extends BaseModule {
    private final List<JumpParticle> particles = new ArrayList<JumpParticle>();
    private final Random random = new Random();
    private boolean wasOnGround = true;
    final class_2960 glowTexture = Rockstar.id("textures/bloom.png");
    final SliderSetting particleCount = new SliderSetting(this, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0447\u0430\u0441\u0442\u0438\u0446").min(10.0f).max(50.0f).step(1.0f).currentValue(20.0f);
    final SliderSetting particleSize = new SliderSetting(this, "\u0420\u0430\u0437\u043c\u0435\u0440 \u0447\u0430\u0441\u0442\u0438\u0446").min(0.1f).max(1.0f).step(0.05f).currentValue(0.3f);
    final SliderSetting spreadDistance = new SliderSetting(this, "\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0440\u0430\u0437\u043b\u0451\u0442\u0430").min(0.5f).max(3.0f).step(0.1f).currentValue(1.5f);
    final SliderSetting lifetime = new SliderSetting(this, "\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438").min(0.5f).max(3.0f).step(0.1f).currentValue(1.5f);
    final SliderSetting smoothness = new SliderSetting(this, "\u041f\u043b\u0430\u0432\u043d\u043e\u0441\u0442\u044c").min(0.1f).max(1.0f).step(0.05f).currentValue(0.5f);
    final SliderSetting particleSpeed = new SliderSetting(this, "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0447\u0430\u0441\u0442\u0438\u0446").min(0.1f).max(2.0f).step(0.1f).currentValue(1.0f);
    final ColorSetting color1 = new ColorSetting(this, "\u0426\u0432\u0435\u0442").color(new ColorRGBA(137.0f, 97.0f, 72.0f, 255.0f));
    final BooleanSetting rainbow = new BooleanSetting(this, "\u0420\u0430\u0434\u0443\u0436\u043d\u044b\u0439").enabled(false);
    private final EventListener<ClientPlayerTickEvent> onTick = event -> {
        if (JumpEffect.mc.field_1724 == null) {
            return;
        }
        boolean isOnGround = JumpEffect.mc.field_1724.method_24828();
        if (this.wasOnGround && !isOnGround && JumpEffect.mc.field_1724.method_18798().field_1351 > 0.0) {
            this.spawnParticles();
        }
        this.wasOnGround = isOnGround;
    };
    private final EventListener<Render3DEvent> onRender3D = event -> {
        if (this.particles.isEmpty()) {
            return;
        }
        class_4587 matrices = event.getMatrices();
        class_4184 camera = JumpEffect.mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.glowTexture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        Iterator<JumpParticle> particleIterator = this.particles.iterator();
        while (particleIterator.hasNext()) {
            JumpParticle particle = particleIterator.next();
            if (particle.isExpired()) {
                particleIterator.remove();
                continue;
            }
            particle.update();
            particle.render(builder, matrices, camera, cameraPos);
        }
        class_9801 builtBuffer = builder.method_60794();
        if (builtBuffer != null) {
            class_286.method_43433((class_9801)builtBuffer);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        matrices.method_22909();
    };

    private void spawnParticles() {
        class_243 playerPos = JumpEffect.mc.field_1724.method_19538();
        int count = (int)this.particleCount.getCurrentValue();
        float spread = this.spreadDistance.getCurrentValue();
        float speedMultiplier = this.particleSpeed.getCurrentValue();
        for (int i = 0; i < count; ++i) {
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double distance = this.random.nextDouble() * (double)spread * 0.15 * (double)speedMultiplier;
            class_243 position = new class_243(playerPos.field_1352, playerPos.field_1351 + 0.05, playerPos.field_1350);
            class_243 velocity = new class_243(Math.cos(angle) * distance, this.random.nextDouble() * 0.02 * (double)speedMultiplier, Math.sin(angle) * distance);
            this.particles.add(new JumpParticle(position, velocity, (long)(this.lifetime.getCurrentValue() * 1000.0f)));
        }
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.particles.clear();
        this.wasOnGround = JumpEffect.mc.field_1724 != null && JumpEffect.mc.field_1724.method_24828();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.particles.clear();
    }

    private class JumpParticle {
        class_243 position;
        class_243 velocity;
        final long startTime;
        final long lifetime;
        final float size;
        final float rotationSpeed;
        float rotation;

        public JumpParticle(class_243 position, class_243 velocity, long lifetime) {
            this.position = position;
            this.velocity = velocity;
            this.startTime = System.currentTimeMillis();
            this.lifetime = lifetime;
            this.size = JumpEffect.this.particleSize.getCurrentValue();
            this.rotation = JumpEffect.this.random.nextFloat() * 360.0f;
            this.rotationSpeed = (JumpEffect.this.random.nextFloat() - 0.5f) * 5.0f;
        }

        public void update() {
            float smoothFactor = JumpEffect.this.smoothness.getCurrentValue();
            this.position = this.position.method_1019(this.velocity);
            this.velocity = this.velocity.method_1021(0.95 * (double)smoothFactor + 0.05);
            this.rotation += this.rotationSpeed * smoothFactor;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > this.lifetime;
        }

        public void render(class_287 builder, class_4587 ms, class_4184 camera, class_243 cameraPos) {
            ColorRGBA particleColor;
            long elapsed = System.currentTimeMillis() - this.startTime;
            float progress = (float)elapsed / (float)this.lifetime;
            float alpha = (float)Math.pow(1.0f - progress, 2.0);
            float scale = this.size * (1.0f + (float)Math.sin((double)progress * Math.PI) * 0.2f);
            ms.method_22903();
            double renderX = this.position.field_1352 - cameraPos.field_1352;
            double renderY = this.position.field_1351 - cameraPos.field_1351;
            double renderZ = this.position.field_1350 - cameraPos.field_1350;
            ms.method_22904(renderX, renderY, renderZ);
            ms.method_22907(camera.method_23767());
            ms.method_22907(class_7833.field_40718.rotationDegrees(this.rotation));
            if (JumpEffect.this.rainbow.isEnabled()) {
                long time = System.currentTimeMillis();
                int hue = (int)(time / 10L % 360L);
                particleColor = ColorRGBA.fromHSB((float)hue / 360.0f, 1.0f, 1.0f).withAlpha(alpha * 255.0f);
            } else {
                particleColor = JumpEffect.this.color1.getColor().withAlpha(alpha * 255.0f);
            }
            Matrix4f matrix = ms.method_23760().method_23761();
            float half = scale / 2.0f;
            builder.method_22918(matrix, -half, -half, 0.0f).method_22913(0.0f, 0.0f).method_22915(particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), particleColor.getAlpha());
            builder.method_22918(matrix, -half, half, 0.0f).method_22913(0.0f, 1.0f).method_22915(particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), particleColor.getAlpha());
            builder.method_22918(matrix, half, half, 0.0f).method_22913(1.0f, 1.0f).method_22915(particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), particleColor.getAlpha());
            builder.method_22918(matrix, half, -half, 0.0f).method_22913(1.0f, 0.0f).method_22915(particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), particleColor.getAlpha());
            ms.method_22909();
        }
    }
}

